<?php

namespace Models/Order;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function client()
    {
        return $this->belongsTo('Client', 'client_id');
    }

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

    public function district()
    {
        return $this->belongsTo('District', 'district_id');
    }

    public function coupon()
    {
        return $this->belongsTo('Coupon', 'coupon_id');
    }

}