<?php

namespace Models/Service;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Service extends Model 
{

    protected $table = 'services';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function serviceCategory()
    {
        return $this->belongsTo('ServiceCategory', 'service_category_id');
    }

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

}