<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCyclesTable extends Migration {

	public function up()
	{
		Schema::create('cycles', function(Blueprint $table) {
			$table->bigIncrements('id', true)->primary();
			$table->bigInteger('statement_id')->unsigned();
			$table->integer('cycle_number');
			$table->datetime('start_date');
			$table->datetime('end_date');
			$table->float('spend');
			$table->integer('number_days');
			$table->string('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('cycles');
	}
}