<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('statement_id')->references('id')->on('statements')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cycles', function(Blueprint $table) {
			$table->foreign('statement_id')->references('id')->on('statements')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('statements', function(Blueprint $table) {
			$table->foreign('contract_id')->references('id')->on('contracts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaigns')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_customer_id_foreign');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->dropForeign('campaigns_account_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_statement_id_foreign');
		});
		Schema::table('cycles', function(Blueprint $table) {
			$table->dropForeign('cycles_statement_id_foreign');
		});
		Schema::table('statements', function(Blueprint $table) {
			$table->dropForeign('statements_contract_id_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_campaign_id_foreign');
		});
	}
}