<?php

namespace App;

class Material extends Eloquent {

	protected $table = 'materials';
	public $timestamps = true;

	public function type()
	{
		return $this->belongsTo('App\Type');
	}

	public function stocks()
	{
		return $this->hasMany('App\Stock', 'material_id');
	}

	public function purchases()
	{
		return $this->hasMany('App\Purchase');
	}

	public function unit()
	{
		return $this->hasOne('App\Unit', 'unit_id');
	}

}