<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('type_requirements', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('type_requirements', function(Blueprint $table) {
			$table->foreign('requirement_id')->references('id')->on('requirements')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('owner_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('event_volunteers', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('event_volunteers', function(Blueprint $table) {
			$table->foreign('volunteer_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('event_guests', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('event_guests', function(Blueprint $table) {
			$table->foreign('nationality_id')->references('id')->on('nationality')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('volunteer_organizes', function(Blueprint $table) {
			$table->foreign('requirement_answer_id')->references('id')->on('requirement_answers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('volunteer_organizes', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('requirements', function(Blueprint $table) {
			$table->foreign('requirement_input_id')->references('id')->on('requirement_input')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('requirement_answers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('requirement_answers', function(Blueprint $table) {
			$table->foreign('type_requirement_id')->references('id')->on('type_requirements')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_type_id_foreign');
		});
		Schema::table('type_requirements', function(Blueprint $table) {
			$table->dropForeign('type_requirements_type_id_foreign');
		});
		Schema::table('type_requirements', function(Blueprint $table) {
			$table->dropForeign('type_requirements_requirement_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_owner_id_foreign');
		});
		Schema::table('event_volunteers', function(Blueprint $table) {
			$table->dropForeign('event_volunteers_event_id_foreign');
		});
		Schema::table('event_volunteers', function(Blueprint $table) {
			$table->dropForeign('event_volunteers_volunteer_id_foreign');
		});
		Schema::table('event_guests', function(Blueprint $table) {
			$table->dropForeign('event_guests_event_id_foreign');
		});
		Schema::table('event_guests', function(Blueprint $table) {
			$table->dropForeign('event_guests_nationality_id_foreign');
		});
		Schema::table('volunteer_organizes', function(Blueprint $table) {
			$table->dropForeign('volunteer_organizes_requirement_answer_id_foreign');
		});
		Schema::table('volunteer_organizes', function(Blueprint $table) {
			$table->dropForeign('volunteer_organizes_city_id_foreign');
		});
		Schema::table('requirements', function(Blueprint $table) {
			$table->dropForeign('requirements_requirement_input_id_foreign');
		});
		Schema::table('requirement_answers', function(Blueprint $table) {
			$table->dropForeign('requirement_answers_user_id_foreign');
		});
		Schema::table('requirement_answers', function(Blueprint $table) {
			$table->dropForeign('requirement_answers_type_requirement_id_foreign');
		});
	}
}