<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EventGuest extends Model 
{

    protected $table = 'event_guests';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('event_id');

    public function event()
    {
        return $this->belongsTo('App\Models\Event');
    }

    public function nationality()
    {
        return $this->belongsTo('App\Models\Nationality');
    }

}