<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function vendor()
    {
        return $this->belongsTo('Vendor');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function items()
    {
        return $this->hasMany('OrderItem');
    }

}