<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCaptainsTable extends Migration {

	public function up()
	{
		Schema::create('captains', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned();
			$table->string('national_id');
			$table->string('vechecle_type');
			$table->string('vechecle_no');
			$table->bigInteger('address_id')->unsigned();
			$table->boolean('approved');
			$table->boolean('status');
			$table->string('image');
		});
	}

	public function down()
	{
		Schema::drop('captains');
	}
}