<?php

namespace App/Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TcForm extends Eloquent {

	protected $table = 'tc_forms';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('tc_question_id', 'tc_form_type_id');

	public function question()
	{
		return $this->belongsTo('App/Model\TcQuestion');
	}

	public function tc_form_type()
	{
		return $this->belongsTo('App/Model\TcFormType');
	}

}