<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRoadsTable extends Migration {

	public function up()
	{
		Schema::create('roads', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('road', 50)->nullable();
			$table->string('length', 20)->nullable();
			$table->string('capacity', 20)->nullable();
			$table->string('intersection_count', 10)->nullable();
			$table->boolean('two_way')->nullable();
			$table->string('longitude', 191)->nullable();
			$table->string('latitude', 191)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('roads');
	}
}