<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCountriesTable extends Migration {

	public function up()
	{
		Schema::create('countries', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->string('name', 90);
			$table->char('slug', 120);
			$table->char('code', 2)->unique();
			$table->integer('primary_league_id');
			$table->boolean('visible');
		});
	}

	public function down()
	{
		Schema::drop('countries');
	}
}