<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFixtureEventsTable extends Migration {

	public function up()
	{
		Schema::create('fixture_events', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('fixture_id')->unsigned();
			$table->char('type', 5);
			$table->smallInteger('time');
			$table->integer('team_id')->unsigned();
			$table->char('player', 120);
			$table->char('assist', 120);
			$table->string('description', 255);
		});
	}

	public function down()
	{
		Schema::drop('fixture_events');
	}
}