<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLeaguesTable extends Migration {

	public function up()
	{
		Schema::create('leagues', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->string('name', 90);
			$table->char('slug', 120);
			$table->integer('country_id')->unsigned();
			$table->boolean('is_cup')->default(false);
			$table->integer('api_id')->unique();
		});
	}

	public function down()
	{
		Schema::drop('leagues');
	}
}