<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractsTable extends Migration {

	public function up()
	{
		Schema::create('contracts', function(Blueprint $table) {
			$table->increments('id');
			$table->date('start_rent_date');
			$table->date('end_rent_date');
			$table->date('due_date')->nullable();
			$table->enum('due_cycle', array('1', '3', '6', '12'));
			$table->boolean('electricity_consum');
			$table->boolean('water_consum');
			$table->integer('electricity_consum_cost');
			$table->integer('water_consum_cost');
			$table->string('contract_num');
			$table->boolean('rent_refresh');
			$table->integer('rent_amount');
			$table->string('file_path');
			$table->integer('estate_id')->unsigned();
			$table->integer('renter_id')->unsigned();
			$table->integer('unit_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contracts');
	}
}