<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMediaTable extends Migration {

	public function up()
	{
		Schema::create('media', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->morphs('mediable');
			$table->string('name', 191);
			$table->string('description', 191);
			$table->string('path', 191);
			$table->string('type', 191);
			$table->string('order', 191);
			$table->string('size', 191);
			$table->boolean('is_main');
		});
	}

	public function down()
	{
		Schema::drop('media');
	}
}