<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductCompetenciesCalculationTable extends Migration {

	public function up()
	{
		Schema::create('Product_competenciesCalculation', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('companiesId');
			$table->string('competenciesId');
			$table->integer('netPurchasePrice');
			$table->integer('grossPurchasePrice');
			$table->enum('vat', array('27', '18', '5', '0'));
			$table->integer('productId');
		});
	}

	public function down()
	{
		Schema::drop('Product_competenciesCalculation');
	}
}