<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersBodyInfoTable extends Migration {

	public function up()
	{
		Schema::create('users_body_info', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->boolean('smoker');
			$table->string('total_cholesterol')->default('null');
			$table->string('hdl_cholesterol')->default('null');
			$table->string('systollic_bp')->default('null');
			$table->boolean('blood_pressure_treated_medicien');
			$table->boolean('chronic_medication');
			$table->string('chronic_medicin_name');
			$table->string('height');
			$table->string('weight');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users_body_info');
	}
}