<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Blog extends Model 
{

    protected $table = 'blogs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function commentsposted()
    {
        return $this->hasMany('Comment', 'blog_id');
    }

    public function likesposted()
    {
        return $this->hasMany('LikeUser', 'entity_id');
    }

}