<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateImagesTable extends Migration {

	public function up()
	{
		Schema::create('images', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
			$table->integer('entity_type')->unsigned();
			$table->integer('entity_id')->unsigned();
			$table->string('image_url', 200);
		});
	}

	public function down()
	{
		Schema::drop('images');
	}
}