<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMemberTable extends Migration {

	public function up()
	{
		Schema::create('member', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->string('name')->nullable();
			$table->string('phone')->nullable();
			$table->string('email')->nullable();
			$table->integer('department_id')->nullable();
			$table->string('position')->nullable();
			$table->integer('work_site_id')->nullable();
			$table->string('office_phone')->nullable();
			$table->integer('city_id')->nullable();
			$table->datetime('birth_date')->nullable();
			$table->enum('gender', array('female', 'male'))->nullable();
			$table->longText('about')->nullable();
			$table->string('password')->nullable();
			$table->string('work_number')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('member');
	}
}