<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCalendarWordTable extends Migration {

	public function up()
	{
		Schema::create('calendar_word', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->text('description')->nullable();
			$table->datetime('from_date')->nullable();
			$table->datetime('to_date')->nullable();
			$table->boolean('hide')->nullable()->default(0);
			$table->integer('member_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('calendar_word');
	}
}