<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostCommentTable extends Migration {

	public function up()
	{
		Schema::create('post_comment', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('post_id')->nullable();
			$table->text('message')->nullable();
			$table->integer('reply_on')->nullable();
			$table->integer('main_thread')->nullable();
			$table->integer('created_by')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('post_comment');
	}
}