<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTaskReportTable extends Migration {

	public function up()
	{
		Schema::create('task_report', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('task_id')->nullable();
			$table->integer('member_id')->nullable();
			$table->string('status')->nullable();
			$table->string('title')->nullable();
			$table->text('report')->nullable();
			$table->string('respond')->nullable();
			$table->text('note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('task_report');
	}
}