<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Attendance extends Eloquent {

	protected $table = 'attendance';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('member_id', 'date', 'from_hour', 'to_hour', 'total_hours', 'sign_in', 'sign_out', 'last_seen', 'month');

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

}