<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Chat extends Eloquent {

	protected $table = 'chat';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('last_message', 'group_id', 'project_id');

	public function group()
	{
		return $this->belongsTo('Group', 'group_id');
	}

	public function project()
	{
		return $this->belongsTo('Project', 'project_id');
	}

	public function members()
	{
		return $this->belongsToMany('Member', 'chat_member', 'member_id', 'chat_id');
	}

}