<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Company extends Eloquent {

	protected $table = 'company';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'about_en', 'about_ar', 'words_en', 'words_ar', 'policy_en', 'policy_ar', 'vision_en', 'vision_ar', 'mission_en', 'mission_ar', 'total_hours', 'folder_id');

	public function folder()
	{
		return $this->belongsTo('Drive', 'folder_id');
	}

}