<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ContractMember extends Eloquent {

	protected $table = 'contract_member';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('contract_id', 'member_id', 'agree');

	public function contract()
	{
		return $this->belongsTo('Contract', 'contract_id');
	}

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

}