<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Experience extends Eloquent {

	protected $table = 'experience';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'description', 'member_id');

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

}