<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Hobby extends Eloquent {

	protected $table = 'hobby';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'member_id');

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

}