<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Invitation extends Eloquent {

	protected $table = 'invitation';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('member_id', 'status');

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

}