<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Member extends Eloquent {

	protected $table = 'member';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'name', 'phone', 'email', 'department_id', 'position', 'work_site_id', 'office_phone', 'city_id', 'birth_date', 'gender', 'about', 'password', 'work_number');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function departments()
	{
		return $this->belongsToMany('Department', 'member_department', 'member_id', 'department_id');
	}

	public function hobbies()
	{
		return $this->hasMany('Hobby', 'member_id');
	}

	public function children()
	{
		return $this->hasMany('ChildName', 'member_id');
	}

	public function experiences()
	{
		return $this->hasMany('Experience', 'member_id');
	}

	public function certifications()
	{
		return $this->hasMany('Certification', 'member_id');
	}

	public function groups()
	{
		return $this->belongsToMany('Group', 'group_member', 'member_id', 'group_id');
	}

	public function projects()
	{
		return $this->belongsToMany('Project', 'project_member', 'member_id', 'project_id');
	}

	public function tasks()
	{
		return $this->hasMany('Task', 'member_id');
	}

	public function posts()
	{
		return $this->hasMany('Post', 'member_id');
	}

	public function notes()
	{
		return $this->hasMany('Note', 'member_id');
	}

	public function contracts()
	{
		return $this->belongsToMany('Contract', 'contract_member', 'member_id', 'contract_id');
	}

	public function city()
	{
		return $this->belongsTo('City', 'city_id');
	}

	public function work_site()
	{
		return $this->belongsTo('City', 'work_site_id');
	}

	public function department()
	{
		return $this->belongsTo('Department', 'department_id');
	}

	public function attendances()
	{
		return $this->hasMany('Attendance', 'member_id');
	}

}