<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Notification extends Eloquent {

	protected $table = 'notification';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('member_id', 'message', 'read');

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

}