<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PostCity extends Eloquent {

	protected $table = 'post_city';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('city_id', 'post_id');

	public function post()
	{
		return $this->belongsTo('Post', 'post_id');
	}

	public function city()
	{
		return $this->belongsTo('City', 'city_id');
	}

}