<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PostReaction extends Eloquent {

	protected $table = 'post_reaction';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('post_id', 'reaction_id', 'created_by');

	public function post()
	{
		return $this->belongsTo('Post', 'post_id');
	}

	public function reaction()
	{
		return $this->belongsTo('Reaction', 'reaction_id');
	}

	public function created_by()
	{
		return $this->belongsTo('Member', 'created_by');
	}

}