<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PostSchedule extends Eloquent {

	protected $table = 'post_schedule';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('post_id', 'date', 'publish');

	public function post()
	{
		return $this->belongsTo('Post', 'post_id');
	}

}