<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Project extends Eloquent {

	protected $table = 'project';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description', 'suggestion_date', 'start_at', 'end_at', 'created_by', 'supervisor_id', 'comment', 'progress', 'status', 'percent', 'group_id', 'folder_id', 'total_days', 'total_members');

	public function group()
	{
		return $this->belongsTo('Group', 'group_id');
	}

	public function created_by()
	{
		return $this->belongsTo('Member', 'created_by');
	}

	public function folder()
	{
		return $this->belongsTo('Drive', 'folder_id');
	}

	public function members()
	{
		return $this->belongsToMany('Member', 'project_member', 'project_id', 'member_id');
	}

	public function tasks()
	{
		return $this->hasMany('Task', 'project_id');
	}

	public function supervisor()
	{
		return $this->belongsTo('Member', 'supervisor_id');
	}

	public function reports()
	{
		return $this->hasMany('ProjectReport', 'project_id');
	}

	public function histories()
	{
		return $this->hasMany('ProjectHistory', 'project_id');
	}

}