<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProjectMember extends Eloquent {

	protected $table = 'project_member';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('member_id', 'project_id', 'rate', 'comment', 'confirm');

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

	public function project()
	{
		return $this->belongsTo('Project', 'project_id');
	}

}