<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Supervisor extends Eloquent {

	protected $table = 'supervisor';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('supervisor_id', 'department_id');

	public function supervisor()
	{
		return $this->belongsTo('Member', 'supervisor_id');
	}

	public function department()
	{
		return $this->belongsTo('Department', 'department_id');
	}

}