<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TaskCommentLike extends Eloquent {

	protected $table = 'task_comment_like';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'created_by', 'comment_id');

	public function created_by()
	{
		return $this->belongsTo('Member', 'created_by');
	}

	public function comment()
	{
		return $this->belongsTo('TaskComment', 'comment_id');
	}

}