<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TaskReport extends Eloquent {

	protected $table = 'task_report';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('task_id', 'member_id', 'status', 'title', 'report', 'respond', 'note');

	public function task()
	{
		return $this->belongsTo('Task', 'task_id');
	}

	public function member()
	{
		return $this->belongsTo('Member', 'member_id');
	}

}