<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerAddressesTable extends Migration {

	public function up()
	{
		Schema::create('customer_addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('customer_id')->unsigned();
			$table->tinyInteger('type');
			$table->string('address_line_1');
			$table->string('address_line_2')->nullable();
			$table->string('city');
			$table->string('state');
			$table->string('country');
			$table->string('zip_code');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customer_addresses');
	}
}