<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGiftCardsTable extends Migration {

	public function up()
	{
		Schema::create('gift_cards', function(Blueprint $table) {
			$table->increments('id');
			$table->string('gift_card_code', 50)->unique();
			$table->string('title');
			$table->string('title_ar')->nullable();
			$table->string('image');
			$table->tinyInteger('is_active')->default('1');
			$table->integer('validity');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('gift_cards');
	}
}