<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWalletDetailsTable extends Migration {

	public function up()
	{
		Schema::create('wallet_details', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('wallet_id')->unsigned();
			$table->decimal('amount');
			$table->enum('transaction_type', array(''Addition'', ''Deduction''));
			$table->string('description')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('wallet_details');
	}
}