<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Cart extends Eloquent {

	protected $table = 'carts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getCustomer()
	{
		return $this->belongsTo('App\Customer');
	}

	public function getCoupon()
	{
		return $this->belongsTo('App\Coupon');
	}

}