<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class GiftCardOrder extends Eloquent {

	protected $table = 'gift_card_orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function customer()
	{
		return $this->belongsTo('App\Customer');
	}

	public function giftCard()
	{
		return $this->belongsTo('App\GiftCard');
	}

}