<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProductRating extends Eloquent {

	protected $table = 'product_ratings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getProduct()
	{
		return $this->belongsTo('App\Product');
	}

	public function getCustomer()
	{
		return $this->belongsTo('App\Customer');
	}

}