<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProductStore extends Eloquent {

	protected $table = 'product_stores';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function product()
	{
		return $this->belongsTo('App\Product');
	}

	public function store()
	{
		return $this->belongsTo('App\Store');
	}

}