<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserCoupon extends Eloquent {

	protected $table = 'customer_coupons';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getCoupon()
	{
		return $this->belongsTo('App\Coupon');
	}

	public function getCustomer()
	{
		return $this->belongsTo('App\Customer');
	}

}