<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomFieldsTable extends Migration {

	public function up()
	{
		Schema::create('custom_fields', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('brand_id')->unsigned();
			$table->string('field_name', 200);
			$table->string('default_value', 200)->nullable();
			$table->text('label_title');
			$table->text('validation');
			$table->enum('field_type', array(''));
			$table->boolean('is_required')->default(0);
			$table->integer('order');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('custom_fields');
	}
}